# Contributing

Looking to contribute to Gibbon? Awesome, you're in the right place. Gibbon is a [work of volunteer labour](https://gibbonedu.org/about/), built with love and passion by people just like you.

You can contribute your time and expertise many ways. For example, you might:

* Write tutorials and “how-to” articles for the [Gibbon documentation](https://gibbonedu.org/support/).
* Help people with the questions they ask on the [Support forum](https://ask.gibbonedu.org).
* [Create a module](https://gibbonedu.org/support/developers/module-development/) that provides additional functionality above and beyond the core.
* Expand our internationalization and [help translate Gibbon](https://gibbonedu.org/support/administrators/multilingual-internationalisation-localisation/) in your language.
* Improve the existing [guides and documentation](https://gibbonedu.org/support/) of features in Gibbon.
* Submit bug reports or hack on Gibbon itself by fixing bugs you've found in the [GitHub Issue tracker](https://github.com/GibbonEdu/core/issues).

> A huge thank you :purple_heart: to our growing team of volunteer developers and translators
> for their ongoing work to make Gibbon better for all of us.


## How to report a bug

Before submitting a bug, please do the following:
1. Make sure you’re on the latest version, your problem may have been solved already!
2. Perform basic troubleshooting steps and note the steps required to reproduce the bug.
3. Check the [bug/issue tracker](https://github.com/GibbonEdu/core/issues) and [planning board](https://trello.com/b/aO7W3YsF/gibbon-v15) to make sure it’s not a known issue.

Submit the bug by [creating an issue](https://github.com/GibbonEdu/core/issues/new) and follow the template provided for what to put in your bug report.

:exclamation: If you find a security vulnerability, do NOT open an issue. Please email support@gibbonedu.org instead.


## How to suggest a feature

To request new features, please use the [Feature Requests category](https://ask.gibbonedu.org/c/feature-requests/12) in our support forums. You can find more info about planned features and upcoming releases on the [Gibbon Development Road Map](https://gibbonedu.org/support/developers/gibbon-road-map/).


## How to help translate

Thanks to some amazing volunteers, Gibbon is available in several different languages. If you would like to help translate Gibbon, please email support@gibbonedu.org. Your help would be most appreciated!


## How to submit a pull request

The Gibbon philosophy is to perform small, easily tested changes to an ongoing development branch. An ideal pull request adds one feature or fixes one bug at a time. If you're unsure where to begin with GitHub feel free to reach out on the [Support forum](https://ask.gibbonedu.org) or check out these great guides: [makeapullrequest.com](http://makeapullrequest.com/) and [opensource.guide](https://opensource.guide/how-to-contribute/)

1. Fork the [GibbonEdu/core](https://github.com/GibbonEdu/core) repository on GitHub and [clone a copy](https://help.github.com/articles/cloning-a-repository/) on your local machine.
2. Write some code and push your changes to your repo using the command line or your [favourite](https://www.sourcetreeapp.com/) Git GUI.
3. Create a [new pull request](https://github.com/GibbonEdu/core/pulls) and fill in the template provided to tell us about your change.
4. Be sure you're submitting your pull request to the development branch _(and not master)_.
5. Submissions should have a [changelog entry](https://github.com/GibbonEdu/core/blob/master/CHANGELOG.txt) noting what was added, changed or fixed.


### _Thanks for reading!_

Following these guidelines helps to communicate that you respect the time of the developers managing and developing this open source project. In return, they'll reciprocate that respect in addressing your issue, assessing changes, and helping you finalize your pull requests.
